#ifndef __MEETING_SERVICE_NETUTIL_BRIDGE_H__
#define __MEETING_SERVICE_NETUTIL_BRIDGE_H__

#include "csf/http/Request.hpp"
#include "csf/http/BasicHttpClient.hpp"
#include "csfunified/framework/UnifiedFactory.h"

#ifdef WIN32
#include "JabberMeeting.h"
using namespace JabberMeeting;
#else
#include "jabber_meeting_sdk_def.h"
using namespace JM_SDK;
#endif

class JMHttpClientListener;

class NetUtilTransport : public INetworkTransport
{
public:
	NetUtilTransport(SMART_PTR_NS::shared_ptr<CSFUnified::UnifiedFactory> unifiedFactory);
	virtual ~NetUtilTransport();

	void HttpRequest(const std::string& httpUrl, const std::vector<std::string>& httpHeader, const std::string& httpPostData, JMHttpMethod httpMethod,
					 NetUtilSuccessProcT successProc, NetUtilErrorProcT errorProc);
	void HttpRequestAsync(const std::string& httpUrl, const std::vector<std::string>& httpHeader, const std::string& httpPostData, JMHttpMethod httpMethod,
						  NetUtilSuccessProcT successProc, NetUtilErrorProcT errorProc);

	bool Registered() {return true;}

	void CancelAllRequest();

protected:
	void BuildRequest(csf::http::RequestPtr request, const std::vector<std::string>& httpHeader, const std::string& httpPostData, JMHttpMethod httpMethod);
	csf::http::BasicHttpClientPtr GetHttpClient();

protected:
	SMART_PTR_NS::shared_ptr<JMHttpClientListener> m_pListener;
	CSFUnified::UnifiedFactoryPtr m_unifiedFactory;
	bool m_bCupMode;
};

namespace NetUtilDownloadResultEnum
{
	enum NetUtilDownloadResult
	{
		OK,
		DOWNLOAD_FAILED,
		FILE_ERROR,
		PARAMETER_ERROR,
		CANCELLED
	};
}

typedef std::function<void(NetUtilDownloadResultEnum::NetUtilDownloadResult result)> NetUtilDownloadProcT;

class NetUtilTransportDownloader : public NetUtilTransport
{
public:
	NetUtilTransportDownloader(SMART_PTR_NS::shared_ptr<CSFUnified::UnifiedFactory> unifiedFactory);
	virtual ~NetUtilTransportDownloader();
	void DownloadToFile(std::string url, std::string filePath, NetUtilDownloadProcT downloadProc, long timeout);
    
private:
	void backgroundDownloadToFile(std::string url, const std::string& filePath, NetUtilDownloadProcT downloadProc);
};

#endif
